/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

/**
 * MosPt[[Npt@CpX[eBeB
 * <p>	2008/11/17	</p>
 * @author m.yoshida
 * @since		1.1.0
 * @version		0.0.3
 */
public class ViewFileLocationUtility {

	/**
	 * jspfBNg
	 */
	private static final String JSP_DIR 	= "/jsp";

	/**
	 * jspt@Cgq
	 */
	private static final String JSP_FILE 	= ".jsp";

	/**
	 * cssfBNg
	 */
	private static final String CSS_DIR 	= "/css";

	/**
	 * csst@Cgq
	 */
	private static final String CSS_FILE 	= ".css";

	/**
	 * jsfBNg
	 */
	private static final String JS_DIR 		= "/js";

	/**
	 * jst@Cgq
	 */
	private static final String JS_FILE 	= ".js";

	/**
	 * pubfBNg
	 */
	private static final String PUB_DIR 	= "/pub";


	/**
	 * pK\
	 */
	private static final String REG_SPRIT	= "\\.";

	/**
	 * MosPWp
	 */
	//private static final String MOSP		= "MosP";

	/**
	 * MosPpbP[Wp
	 */
	private static final String MOSP_PACKAGE = "mosp";

	/**
	 * VoNX
	 */
	private static final String VO			= "Vo";

	/**
	 * jspt@CpX
	 */
	private String retUrl;

	/**
	 * csst@CpX
	 */
	private String extraCss;

	/**
	 * jst@CpX
	 */
	private String extraJs;

	/**
	 * t@CpXpStringBuffer
	 */
	private StringBuffer sb;

	/**
	 * fBNg
	 */
	private String dir;

	/**
	 * t@C
	 */
	private String file;

	/**
	 * RXgN^
	 */
	public ViewFileLocationUtility() {
		retUrl = "";
		extraJs = "";
		extraCss = "";
		sb =  new StringBuffer();
		dir = "";
		file = "";
	}

	/**
	 * RXgN^
	 * @param classname	ΏVoNX
	 * <p> RXgN^̃p[^ɑΏVÕNX{@link BaseVo#getClassName()}ZbgĂяoA<br />
	 * {@link BaseVo#setRetUrl(String)}JSP̃t@CpX{@link ViewFileLocationUtility#getRetUrl()}A<br />
	 * {@link BaseVo#setExtraCss(String)}CSS̃t@CpX{@link ViewFileLocationUtility#getExtraCss()}A<br />
	 * {@link BaseVo#setExtraJs(String)}JS̃t@CpX{@link ViewFileLocationUtility#getExtraJs()}<br />
	 * ꂼZbg邱ƂŁABaseVopĂΏVOɃt@CpXLqȂĂĂяo܂B
	 * </p>
	 * <p>
	 * KƂāAΏVO݂vopbP[Wɍł߂pbP[W
	 * (:jp.mosp.common.vo.MosPLoginVo.javȁꍇcommon)<br />
	 * ΏۃfBNgƂAt@C̓NX̓ɕύXAuVov̂𗘗p܂B<br />
	 * <s>MosPWVȍꍇɗpuMosPv̕܂B</s><br />
	 * iv1.1.25MosP̕gpł悤ɕύX܂Bj<br />
	 * </p>
	 * <p>
	 * (Fjp.mosp.common.vo.MosPLoginVo.javȁꍇ)<br />
	 * jspt@CpX = <s>"/jsp/<b>common</b>/<b>login</b>.jsp"</s>
	 * "/jsp/<b>common</b>/<b>mosPLogin</b>.jsp"
	 * <br />
	 * csst@CpX = <s>"/pub/<b>common</b>/css/<b>login</b>.css"</s>
	 * "/pub/<b>common</b>/css/<b>mosPLogin</b>.css"
	 * <br />
	 * jst@CpX = <s>"/pub/<b>common</b>/js/<b>login</b>.js"</s>
	 * "/pub/<b>common</b>/js/<b>mosPLogin</b>.js"
	 * <br />
	 * </p>
	 * <p>
	 * IvVpbP[WA̓JX^}CYpbP[WKɉ<br>
	 * t@CݒuΎIɐ܂B
	 * </p>
	 * <p>
	 * (Fjp.mosp.option.test.vo.TestVo.javȁꍇ)<br />
	 * jspt@CpX = "/jsp/<b>option/test</b>/<b>test</b>.jsp"<br />
	 * csst@CpX = "/pub/<b>option/test</b>/css/<b>test</b>.css"<br />
	 * jst@CpX = "/pub/<b>option/test</b>/js/<b>test</b>.js"<br />
	 * </p>
	 */
	public ViewFileLocationUtility(String classname) {
		setFilePath(classname);
	}

	/**
	 * t@CpX
	 * @param classname	ΏVoNX
	 * <p>
	 * IvV@\ɑΉ
	 * </p>
	 */
	public void setFilePath(String classname) {
		String[] aryPKG = classname.split(REG_SPRIT);
		// fBNg
		setDir(aryPKG);
		// NXt@C𐶐
		String tmpfile = aryPKG[aryPKG.length -1];
		/*
		 * 		2009/06/18	m.yoshida	mosp-baseΉ
		 */
		/*		
		if (tmpfile.startsWith(MOSP)) {
			tmpfile = tmpfile.split(MOSP)[1];
		}
		 */		
		setFile(convHeadUpperCaseToLowerCase(tmpfile.split(VO)[0]));
		createRetUrl();
		createExtraCss();
		createExtraJs();
	}

	/**
	 * fBNg
	 * @param aryPKG pbP[Wz
	 */
	private void setDir(String[] aryPKG) {
		sb = new StringBuffer();
		/*
		 * 		2009/05/25	m.yoshida	ipbP[WɑΉ
		 */
		/*
		// ƃpbP[W
		String bizPKG = aryPKG[aryPKG.length -4];
		// @\pbP[W
		String functionPKG = aryPKG[aryPKG.length -3];
		// pbP[W
		if (!bizPKG.equals(MOSP_PACKAGE)) {
			sb.append(bizPKG);
			sb.append("/");
		}
		sb.append(functionPKG);
		 */		
		sb.append(getFunctionDir(aryPKG));
		setDir(sb.toString());
	}

	/**
	 * fBNg
	 * <p>	2009/05/25	m.yoshida	ipbP[WɑΉ	</p>
	 * @param aryPKG pbP[Wz
	 * @return	fBNg
	 */
	private StringBuffer getFunctionDir(String[] aryPKG) {
		StringBuffer sb = new StringBuffer();
		// Jn
		int start = 2;
		// I
		int end = aryPKG.length -2;
		// jp.coAjp.mosppbP[WȊȌꍇ
		if (!aryPKG[1].equals("co")
				&& !aryPKG[1].equals(MOSP_PACKAGE)
		) {
			start = 1;
		}
		for (int i = start; i < end; i++) {
			sb.append(aryPKG[i]);
			if (i != end -1) {
				sb.append("/");
			}
		}
		return sb;
	}

	/**
	 * jspt@CpX
	 */
	private void createRetUrl() {
		sb = new StringBuffer();
		sb.append(JSP_DIR);
		sb.append("/");
		sb.append(getDir());
		sb.append("/");
		sb.append(getFile());
		sb.append(JSP_FILE);
		setRetUrl(sb.toString());
	}

	/**
	 * csst@CpX
	 */
	private void createExtraCss() {
		sb = new StringBuffer();
		sb.append(PUB_DIR);
		sb.append("/");
		sb.append(getDir());
		sb.append(CSS_DIR);
		sb.append("/");
		sb.append(getFile());
		sb.append(CSS_FILE);
		setExtraCss(sb.toString());
	}

	/**
	 * jst@CpX
	 */
	private void createExtraJs() {
		sb = new StringBuffer();
		sb.append(PUB_DIR);
		sb.append("/");
		sb.append(getDir());
		sb.append(JS_DIR);
		sb.append("/");
		sb.append(getFile());
		sb.append(JS_FILE);
		setExtraJs(sb.toString());
	}

	/**
	 * jspt@CpXgetter
	 * @return	retUrl	jspt@CpX
	 */
	public String getRetUrl() { return retUrl; }

	/**
	 * jspt@CpXsetter
	 * @param retUrl	jspt@CpX
	 */
	private void setRetUrl(String retUrl) { this.retUrl = retUrl; }

	/**
	 * csst@CpXgetter
	 * @return	extraCss	csst@CpX
	 */
	public String getExtraCss() { return extraCss; }

	/**
	 * csst@CpXsetter
	 * @param extraCss	csst@CpX
	 */
	private void setExtraCss(String extraCss) { this.extraCss = extraCss; }

	/**
	 * jst@CpXgetter
	 * @return	extraJs	jst@CpX
	 */
	public String getExtraJs() { return extraJs; }

	/**
	 * jst@CpXsetter
	 * @param extraJs	jst@CpX
	 */
	private void setExtraJs(String extraJs) { this.extraJs = extraJs; }

	/**
	 * fBNggetter
	 * @return	dir	fBNg
	 */
	private String getDir() { return dir; }

	/**
	 * fBNgsetter
	 * @param dir	fBNg
	 */
	private void setDir(String dir) { this.dir = dir; }

	/**
	 * t@Cgetter
	 * @return	file	t@C
	 */
	private String getFile() { return file; }

	/**
	 * t@Csetter
	 * @param file	t@C
	 */
	private void setFile(String file) { this.file = file; }

	/**
	 * 擪ϊ
	 * @param str	Ώە
	 * @return	sb	擪̑啶ɕϊ̑Ώە
	 */
	private String convHeadUpperCaseToLowerCase(String str) {
		StringBuffer sb = new StringBuffer(str);
		String head = sb.substring(0, 1);
		sb = sb.delete(0, 1);
		head = head.toLowerCase();
		sb.insert(0, head);
		return sb.toString();
	}

}
